pro Datecon, year, day, month, date

;+
; DATECON
;	Given year and doy returns month and date.
;
; Usage:
;	datecon, year, day, month, date
;
; Arguments:
;	year	int	input	Year (only needed to check for Leap
;				Year).
;	day	int	input	Day of year.
;	month	string	output	The month in which day lies.
;	date	int	output	The day of the month of day.
;
; Restrictions:
;	Year must be scalar. Fails for non-400 centuries. Out of range
;	day will crash.
;
; History:
;	Original: 16/2/95; SJT
;-

mons = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', $
        'Oct', 'Nov', 'Dec']
ofs = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 366]
ofs(2:*) =  ofs(2:*)+((year mod 4) eq 0)

mon = [replicate(0, 31), $
       replicate(1, 28+((year mod 4) eq 0)), $
       replicate(2, 31), $
       replicate(3, 30), $
       replicate(4, 31), $
       replicate(5, 30), $
       replicate(6, 31), $
       replicate(7, 31), $
       replicate(8, 30), $
       replicate(9, 31), $
       replicate(10, 30), $
       replicate(11, 31)]

imon = mon(day-1)
month = mons(imon)
date = day-ofs(imon)

end
